	subroutine vexp(n,ndim,k,kdim,dlambda,eps)
c**********************************************************************
c
c   FORTRAN subroutine to generate vector exponential noise having
c   mean dlambda.
c 
c   Input: n = an integer containing the number of observations.
c          ndim = an integer containing the number of rows of x in the
c                 calling routine.
c          k = an integer containing the number of components of the
c              realization.
c          kdim = an integer containing the number of rows of sigma
c                 in the calling routine.
c          dlambda = a double precision scalar containing the mean.
c
c   Output: eps = a double precision matrix of dimension n x k containing
c                 the desired realization.
c
c   Subprograms called: (IMSL) DRNEXP
c
c   Written: 9/16/99 JLH
c
c**********************************************************************
c
	implicit double precision (a-h,p-z)
	integer n, ndim, k, kdim
	double precision dlambda, eps(ndim,kdim)
c
c   Use IMSL subroutines.
c
	do i = 1,k
		call DRNEXP(n,eps(1,i))
	enddo
c
	do i = 1,n
	do j = 1,k
		eps(i,j) = dlambda*eps(i,j)
	enddo
	enddo
c
	return
	end